<?php
require __DIR__.'/config.php';
date_default_timezone_set('Africa/Nairobi');

header('Access-Control-Allow-Origin: *');
header('Vary: Origin');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With');
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD']==='OPTIONS'){http_response_code(204);exit;}

function pdo(): PDO {
  if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo'];
  return getPdoConnection();
}
function assert_admin(PDO $pdo, string $token){
  $q=$pdo->prepare("SELECT id FROM admin_users WHERE token=? LIMIT 1");
  $q->execute([$token]); if(!$q->fetchColumn()){ http_response_code(401); echo json_encode(['success'=>false,'message'=>'Admin token required']); exit; }
}

$authz = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$token = preg_replace('/^Bearer\s+/i','',$authz);
if(!$token){http_response_code(401);echo json_encode(['success'=>false,'message'=>'Missing token']);exit;}
$pdo=pdo(); assert_admin($pdo,$token);

$org_id = isset($_GET['org_id'])?(int)$_GET['org_id']:0;
if(!$org_id){ http_response_code(422); echo json_encode(['success'=>false,'message'=>'org_id required']); exit; }

$stmt=$pdo->prepare("SELECT * FROM shifts WHERE org_id=? AND active=1 ORDER BY start_time");
$stmt->execute([$org_id]);
echo json_encode(['success'=>true,'shifts'=>$stmt->fetchAll()]);
