<?php
// guardianapi/config.php
declare(strict_types=1);

/**
 * Global configuration for GuestPass VMS + Guardian Assist APIs.
 * - MySQL (mysqli) connection helper
 * - Timezone + encoding
 * - SMTP (PHPMailer) settings
 * - SMS settings (TEXTSMS OTP endpoint) + legacy aliases
 * - Small utility helpers used around the API
 */

/* =========================
 * Environment & Timezone
 * ========================= */
define('GP_ENV', getenv('GP_ENV') ?: 'prod'); // 'dev' or 'prod'
define('APP_TIMEZONE', 'Africa/Nairobi');
@date_default_timezone_set(APP_TIMEZONE);

// Errors: verbose in dev, quiet in prod
if (GP_ENV === 'dev') {
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
  error_reporting(E_ALL);
  ini_set('display_errors', '1');
} else {
  mysqli_report(MYSQLI_REPORT_OFF);
  error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);
  ini_set('display_errors', '0');
}

/* =========================
 * Database (MySQL / mysqli)
 * ========================= */
define('DB_HOST', 'localhost');
define('DB_NAME', 'asbdpijm_multitenancy_client');          // e.g., 'guestpass'
define('DB_USER', 'asbdpijm_shemking');     // e.g., 'guestpass_user'
define('DB_PASS', 'Shemking@18');
define('PUBLIC_BASE_URL', 'hhttps://api.parkspace.co.ke/guestpassmultitenancy/guardianapi/guardianapi/');

function getDbConnection(): mysqli {
  static $conn = null;
  if ($conn instanceof mysqli) {
    return $conn;
  }
  $conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
  if ($conn->connect_errno) {
    http_response_code(500);
    echo json_encode(['status'=>'error','message'=>'DB connection failed']);
    exit;
  }
  $conn->set_charset('utf8mb4');
  return $conn;
}

/* =========================
 * Roles & Super-admin
 * ========================= */
// Superadmin org id(s). We used org 0 and 7 in earlier logic.
define('SUPERADMIN_ORG_ID', 7);

/* =========================
 * SMTP (PHPMailer) Settings
 * =========================
 * Used by registerorg.php and send_visitor_alert.php
 */
// ✏️ If you use the cPanel mailbox shown earlier, fill these in:
define('SMTP_HOST', 'mail.parkspace.co.ke');
define('SMTP_PORT', 587); // 587 (TLS) or 465 (SMTPS)
define('SMTP_SECURE', 'tls'); // 'tls' or 'ssl'
define('SMTP_USERNAME', 'guestpass@parkspace.co.ke');
define('SMTP_PASSWORD', 'REPLACE_WITH_SMTP_PASSWORD'); // ← put the real mailbox password
define('SMTP_FROM',     'guestpass@parkspace.co.ke');
define('SMTP_FROM_NAME','GuestPass Support');

/* =========================
 * SMS Provider (TEXTSMS OTP)
 * =========================
 * We switched to the dedicated OTP endpoint for immediate delivery.
 * Both POST and GET are supported. Our sms_send.php uses POST.
 */
// ✏️ Fill with your real creds from TEXTSMS:
define('TEXTSMS_BASE',      'https://sms.textsms.co.ke/api/services/'); // trailing slash required
define('TEXTSMS_APIKEY',    '41c2aa6e25d87f2e0e26d2a147d21ce5');
define('TEXTSMS_PARTNER',   '14186');
define('TEXTSMS_SHORTCODE', 'Signal VMS'); // or your registered sender/shortcode

// Name to store in DB logs as provider label:
define('SMS_PROVIDER', 'TEXTSMS'); // kept for compatibility with existing code

/* =========================
 * Legacy SMS Constants (Compat)
 * =========================
 * Some older code referenced SMS_* constants. Map them to TEXTSMS so
 * nothing breaks if any legacy script still includes config.php.
 */
if (!defined('SMS_BASE'))     define('SMS_BASE', TEXTSMS_BASE);
if (!defined('SMS_APIKEY'))   define('SMS_APIKEY', TEXTSMS_APIKEY);
if (!defined('SMS_PARTNER'))  define('SMS_PARTNER', TEXTSMS_PARTNER);
if (!defined('SMS_SHORTCODE'))define('SMS_SHORTCODE', TEXTSMS_SHORTCODE);

/* =========================
 * Small Utilities
 * ========================= */

/** Simple env getter with default */
function gp_env(string $key, $default = null) {
  $v = getenv($key);
  return $v !== false ? $v : $default;
}

/** Normalise MSISDN to +CCCxxxxxxxxx (very light touch) */
function gp_normalize_msisdn(string $m): string {
  $m = trim($m);
  // Keep digits and plus
  $m = preg_replace('/[^\d+]/', '', $m);
  // If it starts with 00, convert to +
  $m = preg_replace('/^00/', '+', $m);
  // If it starts with 0 and you want to assume Kenya (+254),
  // uncomment the next two lines:
  // if (preg_match('/^0\d{9}$/', $m)) {
  //   $m = '+254' . substr($m, 1);
  // }
  return $m;
}

/** JSON input helper (assoc array) */
function gp_json_input(): array {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}

/** Consistent JSON output + exit */
function gp_respond(array $arr, int $code = 200): void {
  http_response_code($code);
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode($arr);
  exit;
}

/** Current timestamp as MySQL DATETIME */
function gp_now(): string {
  return date('Y-m-d H:i:s');
}

/** Allow simple CORS (index.php already sets headers; keep here for reuse if needed) */
function gp_set_cors_all(): void {
  header("Access-Control-Allow-Origin: *");
  header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
  header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
}


