<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'config.php';
$conn = getDbConnection();

if (!$conn) {
    echo json_encode(["status" => "error", "message" => "Database connection failed"]);
    exit();
}

// Date filters
$start = isset($_GET['start']) ? $_GET['start'] : null;
$end = isset($_GET['end']) ? $_GET['end'] : null;
$dateClause = "";

if ($start && $end) {
    $dateClause = "created_at BETWEEN '$start 00:00:00' AND '$end 23:59:59'";
} else {
    $dateClause = "1"; // no filter
}

function fetchData($conn, $query, $keyLabel, $valueLabel) {
    $result = $conn->query($query);
    $data = [];
    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = [
                $keyLabel => $row[$keyLabel],
                $valueLabel => (int)$row[$valueLabel]
            ];
        }
    }
    return $data;
}

// Totals
$today = $conn->query("SELECT COUNT(*) as total FROM visitor_records WHERE DATE(created_at) = CURDATE()")->fetch_assoc()['total'];
$week = $conn->query("SELECT COUNT(*) as total FROM visitor_records WHERE YEARWEEK(created_at, 1) = YEARWEEK(CURDATE(), 1)")->fetch_assoc()['total'];
$month = $conn->query("SELECT COUNT(*) as total FROM visitor_records WHERE MONTH(created_at) = MONTH(CURDATE()) AND YEAR(created_at) = YEAR(CURDATE())")->fetch_assoc()['total'];

// Filtered queries
$hourly = fetchData($conn, "
    SELECT HOUR(created_at) as hour, COUNT(*) as count 
    FROM visitor_records 
    WHERE $dateClause
    GROUP BY HOUR(created_at)
    ORDER BY hour ASC
", "hour", "count");

$by_guard = fetchData($conn, "
    SELECT admitted_by as guard, COUNT(*) as count 
    FROM visitor_records 
    WHERE $dateClause
    GROUP BY admitted_by
    ORDER BY count DESC
", "guard", "count");

$by_description = fetchData($conn, "
    SELECT description, COUNT(*) as count 
    FROM visitor_records 
    WHERE $dateClause
    GROUP BY description
    ORDER BY count DESC
", "description", "count");

$daily = fetchData($conn, "
    SELECT DATE(created_at) as day, COUNT(*) as count 
    FROM visitor_records 
    WHERE $dateClause
    GROUP BY DATE(created_at)
    ORDER BY day ASC
", "day", "count");

echo json_encode([
    "status" => "success",
    "data" => [
        "totals" => [
            "today" => (int)$today,
            "this_week" => (int)$week,
            "this_month" => (int)$month
        ],
        "hourly" => $hourly,
        "by_guard" => $by_guard,
        "by_description" => $by_description,
        "daily" => $daily
    ]
]);

$conn->close();
exit();
?>